<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'logo', 'area_id', 'min_order', 'delivery_fee', 'status', 'avg_rate', 'contact_phone', 'whatsapp_number', 'is_active');

    public function meals()
    {
        return $this->hasMany('App\Models\Meal');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function offers()
    {
        return $this->hasMany('App\Models\Offer');
    }

    public function categories()
    {
        return $this->hasMany('App\Models\Category');
    }

    public function commissions()
    {
        return $this->hasMany('App\Models\Commission');
    }

    public function notifcations()
    {
        return $this->morphMany('App\Models\Notification');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

}